package permissions

import (
	"context"

	"github.com/pkg/errors"
)

// CanReadSuspension returns true if a user can read a specific suspension
//
// BeefcakePermission: aegis_suspension_read
//
func CanReadSuspension(ctx context.Context) (bool, error) {
	p, ok := ctx.Value(MyPermissions).(UserPermissions)
	if !ok {
		return false, errors.WithStack(ErrPermissionsMissing)
	}

	return p.IsPermitted(SuspensionRead), nil
}

// CanIssueSuspension returns true if a user can issue suspensions
//
// BeefcakePermission: support_tools
//
func CanIssueSuspension(ctx context.Context) (bool, error) {
	p, ok := ctx.Value(MyPermissions).(UserPermissions)
	if !ok {
		return false, errors.WithStack(ErrPermissionsMissing)
	}

	return p.IsPermitted(SupportTools), nil
}
