package permissions

import (
	"context"

	"github.com/pkg/errors"
)

// CanDeleteUserContent returns ture if current user has permission to remove contents generated by a twitch user
//
// BeefcakePermission: SupportTools
//
func CanDeleteUserContent(ctx context.Context) (bool, error) {
	p, ok := ctx.Value(MyPermissions).(UserPermissions)
	if !ok {
		return false, errors.WithStack(ErrPermissionsMissing)
	}

	return p.IsPermitted(SupportTools), nil
}
