package permissions

import (
	"context"
	"testing"

	"github.com/pkg/errors"
	"github.com/stretchr/testify/assert"
)

func TestCanDeleteUserContent(t *testing.T) {
	testCases := []struct {
		permissions UserPermissions
		canRead     bool
	}{
		{
			permissions: AllowNone(),
			canRead:     false,
		},
		{
			permissions: AllowFor(SupportTools),
			canRead:     true,
		},
	}

	for _, testCase := range testCases {
		ctx := context.WithValue(context.Background(), MyPermissions, testCase.permissions)

		perm, err := CanDeleteUserContent(ctx)
		assert.NoError(t, err)
		assert.Equal(t, testCase.canRead, perm)
	}
}

func TestCanDeleteUserContentErrors(t *testing.T) {
	ctx := context.Background()
	perm, err := CanDeleteUserContent(ctx)
	assert.Equal(t, ErrPermissionsMissing, errors.Cause(err))
	assert.False(t, perm)
}
