package reports

import (
	"strings"

	"code.justin.tv/safety/datastore/models/reportcontent"
)

var (
	// List of report content that we want to display differently than default format
	reportContentDisplayOverrides = map[string]string{
		reportcontent.Vod:        "VOD",
		reportcontent.VodComment: "VOD comment",
	}
)

// ToDisplayContent converts a datastore content into a display content
// `sings_comment_report` will be converted to `Sings comment`
func ToDisplayContent(content string) string {
	if display, ok := reportContentDisplayOverrides[content]; ok {
		return display
	}
	return strings.Replace(strings.Title(strings.TrimSuffix(content, "_report")), "_", " ", -1)
}
