package reports

import (
	"testing"

	"code.justin.tv/safety/datastore/models/reportcontent"
	"github.com/stretchr/testify/assert"
)

func TestToDisplayContent(t *testing.T) {
	assert.Equal(t, "Display content", ToDisplayContent("display_content_report"))
	assert.Equal(t, "No report suffix", ToDisplayContent("no_report_suffix"))
	assert.Equal(t, "Repeat repeat word", ToDisplayContent("repeat_repeat_word_report"))
	assert.Equal(t, "Oneword", ToDisplayContent("oneword"))
	assert.Equal(t, "", ToDisplayContent(""))

	assert.Equal(t, "VOD", ToDisplayContent(reportcontent.Vod))
	assert.Equal(t, "VOD comment", ToDisplayContent(reportcontent.VodComment))
}
