package reports

import "code.justin.tv/safety/datastore/models"

// Predicate is a function to test a report
// the function should return true only if the argument matches the predicate
type Predicate func(*models.Report) bool

// Filter will return a new slice of reports which passes predicate
func Filter(reports []*models.Report, predicate Predicate) []*models.Report {
	results := make([]*models.Report, 0, len(reports))
	for _, r := range reports {
		if predicate(r) {
			results = append(results, r)
		}
	}
	return results
}
