package reports

import (
	"testing"

	"code.justin.tv/safety/datastore/models"

	"github.com/stretchr/testify/assert"
)

func TestFilterReport(t *testing.T) {
	r1 := &models.Report{
		ID: 1,
	}
	r2 := &models.Report{
		ID: 2,
	}
	input := []*models.Report{r1, r2}

	result := Filter(input, func(r *models.Report) bool {
		return r.ID == r2.ID
	})

	assert.Equal(t, 1, len(result))
	assert.Equal(t, r2, result[0])
}
