package reports

import (
	"testing"

	"code.justin.tv/safety/datastore/models"

	"github.com/stretchr/testify/assert"
)

func TestGroupByTargetUser(t *testing.T) {
	t.Parallel()

	userID1 := 1
	userID2 := 2
	userID3 := 3

	r1 := &models.Report{
		ID:           1,
		TargetUserID: &userID1,
	}
	r2 := &models.Report{
		ID:           2,
		TargetUserID: &userID2,
	}
	r3 := &models.Report{
		ID:           3,
		TargetUserID: &userID1,
	}
	r4 := &models.Report{
		ID:           4,
		TargetUserID: &userID3,
	}
	r5 := &models.Report{
		ID:           5,
		TargetUserID: &userID1,
	}
	input := []*models.Report{r1, r2, r3, r4, r5}

	result := GroupByTargetUser(input, 2)
	assert.Equal(t, []*models.Report{r1, r3, r5}, result)

	result = GroupByTargetUser(input, 3)
	assert.Equal(t, []*models.Report{r1, r3, r5}, result)

	result = GroupByTargetUser(input, 4)
	assert.Equal(t, []*models.Report{r1, r3, r5, r2}, result)
}
