package reports

import (
	"strings"

	"code.justin.tv/safety/datastore/models/reportreason"
)

var (
	// List of report reasons that we want to display differently than default format
	reportReasonDisplayOverrides = map[string]string{
		reportreason.Ddos:          "DDOS",
		reportreason.SelfHarm:      "Self-harm",
		reportreason.TosBanEvasion: "TOS ban evasion",
	}
)

// ToDisplayReason converts a datastore reason into a display reason
// `sexual_content` will be converted to `Sexual content`
func ToDisplayReason(reason string) string {
	if display, ok := reportReasonDisplayOverrides[reason]; ok {
		return display
	}

	return strings.Replace(strings.Title(reason), "_", " ", -1)
}
