package reports

import (
	"testing"

	"code.justin.tv/safety/datastore/models/reportreason"

	"github.com/stretchr/testify/assert"
)

func TestToDisplayReason(t *testing.T) {
	assert.Equal(t, "Display reason", ToDisplayReason("display_reason"))
	assert.Equal(t, "Oneword", ToDisplayReason("oneword"))
	assert.Equal(t, "", ToDisplayReason(""))

	assert.Equal(t, "DDOS", ToDisplayReason(reportreason.Ddos))
	assert.Equal(t, "Self-harm", ToDisplayReason(reportreason.SelfHarm))
	assert.Equal(t, "TOS ban evasion", ToDisplayReason(reportreason.TosBanEvasion))

}
