package reports

import (
	"sort"

	"code.justin.tv/safety/datastore/models"
)

// Sort the reports according to their priority
// Highest priority report will be at first
func Sort(reports []*models.Report) {
	sort.Sort(sortableReports(reports))
}

type sortableReports []*models.Report

func (r sortableReports) Len() int {
	return len(r)
}

// Less returns true if report on the left has
// higher priority than report on the right
func (r sortableReports) Less(i, j int) bool {
	return Priority(r[i]) > Priority(r[j])
}

func (r sortableReports) Swap(i, j int) {
	temp := r[i]
	r[i] = r[j]
	r[j] = temp
}
