package reports

import (
	"testing"
	"time"

	"code.justin.tv/safety/datastore/models"
	"code.justin.tv/safety/datastore/models/reportreason"
	"code.justin.tv/safety/datastore/models/reportusertype"

	"github.com/stretchr/testify/assert"
)

func TestSort(t *testing.T) {
	lowPriorityReport := models.Report{
		ID:           1,
		Content:      strPtr("content"),
		Reason:       strPtr(reportreason.Spam),
		FromUserType: nil,
		FromUserID:   intPtr(1),
		CreatedAt:    time.Now(),
	}

	mediumPriorityReport := models.Report{
		ID:           2,
		Content:      strPtr("content"),
		Reason:       strPtr(reportreason.BitsViolation),
		FromUserType: strPtr(reportusertype.Staff),
		FromUserID:   intPtr(1),
		CreatedAt:    time.Now().Add(-1 * time.Hour),
	}

	highPriorityReport := models.Report{
		ID:           3,
		Content:      strPtr("content"),
		Reason:       strPtr(reportreason.SelfHarm),
		FromUserType: strPtr(reportusertype.Ceo),
		FromUserID:   intPtr(1),
		CreatedAt:    time.Now().Add(-10 * time.Hour),
	}

	reports := []*models.Report{&mediumPriorityReport, &highPriorityReport, &lowPriorityReport}
	Sort(reports)

	assert.Equal(t, 3, len(reports))
	assert.Equal(t, &highPriorityReport, reports[0])
	assert.Equal(t, &mediumPriorityReport, reports[1])
	assert.Equal(t, &lowPriorityReport, reports[2])
}

func intPtr(i int) *int {
	return &i
}

func strPtr(s string) *string {
	return &s
}
