package server

import (
	"context"
	"fmt"
	"net/http"

	"code.justin.tv/common/config"

	"github.com/jixwanwang/apiutils"
	"github.com/pkg/errors"

	"code.justin.tv/chat/golibs/logx"
)

// ServeError serves error back
func ServeError(ctx context.Context, w http.ResponseWriter, message string, respCode int, err error) {
	if err != nil {
		err = errors.WithMessage(err, message)
	} else {
		err = errors.New(message)
	}

	if respCode < 500 { // Log non internal errors as info
		logx.Info(ctx, err)
	} else {
		logx.Error(ctx, err)
	}

	statter := config.Statsd()
	_ = statter.Inc(fmt.Sprintf("request.error.%d", respCode), 1, 1)

	apiutils.ServeError(w, apiutils.NewErrorResponse(respCode, message))
}
