package tracking

import (
	"code.justin.tv/hygienic/spade"

	"code.justin.tv/safety/datastore/models"
)

const (
	// aegisAutoresolveRuleCancel is the spade event name for cancelling an existing auto resolve rules
	aegisAutoresolveRuleCancel = "aegis_autoresolve_rule_cancel"
)

// AutoresolveRuleCancel is an event for cancelling an existing autoresolve rules
type AutoresolveRuleCancel struct {
	AdminID           int64  `json:"admin_id"`
	AutoresolveRuleID int64  `json:"autoresolve_rule_id"`
	CancelAtSecond    int64  `json:"cancel_at_second"`
	Environment       string `json:"environment"`
	RemainingSecond   int64  `json:"remaining_second"`
}

// TrackAutoresolveRuleCancel tracks when an admin cancels an existing auto resolve rule
func (c *Client) TrackAutoresolveRuleCancel(autoresolve models.AutoResolve, canceledBy int64) {
	c.spade.QueueEvents(spade.Event{
		Name: aegisAutoresolveRuleCancel,
		Properties: AutoresolveRuleCancel{
			AdminID:           canceledBy,
			AutoresolveRuleID: autoresolve.ID,
			Environment:       c.environment,
			CancelAtSecond:    int64(autoresolve.DisabledAt.Sub(autoresolve.CreatedAt).Seconds()),
			RemainingSecond:   int64(autoresolve.ResolveUtil.Sub(*autoresolve.DisabledAt).Seconds()),
		},
	})
}
