package tracking

import (
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	"code.justin.tv/safety/datastore/models"
)

func TestTrackAutoresolveCancel(t *testing.T) {
	c, s := testClient()

	adminID := int64(999)
	canceledAtSeconds := int64(400)
	remainingSeconds := int64(600)

	createdAt := time.Now()
	disabledAt := createdAt.Add(time.Duration(canceledAtSeconds) * time.Second)
	autoresolveUntil := createdAt.Add(time.Duration(canceledAtSeconds+remainingSeconds) * time.Second)

	autoresolve := models.AutoResolve{
		ID:          123,
		CreatedAt:   createdAt,
		DisabledAt:  &disabledAt,
		ResolveUtil: &autoresolveUntil,
	}

	c.TrackAutoresolveRuleCancel(autoresolve, adminID)

	events := s.GetEvents()
	require.Equal(t, 1, len(events))
	event := events[0]
	assert.Equal(t, aegisAutoresolveRuleCancel, event.Name)
	assert.Equal(t, AutoresolveRuleCancel{
		AdminID:           adminID,
		AutoresolveRuleID: autoresolve.ID,
		Environment:       testEnvironment,
		CancelAtSecond:    canceledAtSeconds,
		RemainingSecond:   remainingSeconds,
	}, event.Properties)
}
