package tracking

import (
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	"code.justin.tv/safety/datastore/models"
)

func TestTrackAutoresolveCreate(t *testing.T) {
	c, s := testClient()

	adminID := int64(999)
	totalDuration := int64(1000)
	fromUserID := 1234
	fromUserType := autoresolveUserIs
	targetUserID := 9876
	targetUserDBID := targetUserID * -1 //  TODO replace this in https://jira.twitch.com/browse/SAFETY-1523
	targetUserType := autoresolveUserNot
	reason := "reason"
	content := "content"

	createdAt := time.Now()
	autoresolveUntil := createdAt.Add(time.Duration(totalDuration) * time.Second)

	autoresolve := models.AutoResolve{
		ID:           123,
		CreatedAt:    createdAt,
		CreatedBy:    &adminID,
		ResolveUtil:  &autoresolveUntil,
		Reason:       &reason,
		Content:      &content,
		FromUserID:   &fromUserID,
		TargetUserID: &targetUserDBID,
	}

	c.TrackAutoresolveRuleCreate(autoresolve)

	events := s.GetEvents()
	require.Equal(t, 1, len(events))
	event := events[0]
	assert.Equal(t, aegisAutoresolveRuleCreate, event.Name)
	fromUserIDInt64 := int64(fromUserID)
	targetUserIDInt64 := int64(targetUserID)
	assert.Equal(t, AutoresolveRuleCreate{
		AdminID:            adminID,
		AutoresolveRuleID:  autoresolve.ID,
		Environment:        testEnvironment,
		TargetUserID:       &targetUserIDInt64,
		TargetUserRuleType: &targetUserType,
		FromUserID:         &fromUserIDInt64,
		FromUserRuleType:   &fromUserType,
		RestrictToContent:  autoresolve.Content,
		RestrictToReason:   autoresolve.Reason,
		SetUpSecond:        totalDuration,
	}, event.Properties)
}
