package tracking

import (
	"code.justin.tv/common/config"
	"code.justin.tv/hygienic/spade"
	fakespade "code.justin.tv/safety/aegis/internal/tracking/mocks"
)

// Spade is the interface for hygienic/spade
type Spade interface {
	QueueEvents(events ...spade.Event)
	Start() error
	Close() error
}

// Client is a client to track aegis usage and send them as spade events
type Client struct {
	spade       Spade
	environment string
}

// New creates a new tracking client to track aegis usage
func New(spadeConfig spade.Config) (*Client, error) {
	spadeClient := &spade.Client{
		Config: spadeConfig,
	}

	err := spadeClient.Setup()
	if err != nil {
		return nil, err
	}

	return &Client{
		spade:       spadeClient,
		environment: config.Environment(),
	}, nil
}

// NewFake creates a fake tracking client
func NewFake(environment string) *Client {
	return &Client{
		spade:       &fakespade.FakeSpade{},
		environment: environment,
	}
}

// Close wait for events to be sent. This should be called before application closes
func (c *Client) Close() error {
	return c.spade.Close()
}

// Start starts the spade client.
func (c *Client) Start() error {
	return c.spade.Start()
}
