package spade

import "code.justin.tv/hygienic/spade"

// FakeSpade is a fake client of hygienic/spade
type FakeSpade struct {
	events []spade.Event
}

// QueueEvents queues the events that can be obtained later
func (s *FakeSpade) QueueEvents(e ...spade.Event) {
	s.events = append(s.events, e...)
}

// GetEvents returns all events queued
func (s *FakeSpade) GetEvents() []spade.Event {
	return s.events
}

// Close is here to complete the interface
func (s *FakeSpade) Close() error {
	return nil
}

// Start is here to complete the interface
func (s *FakeSpade) Start() error {
	return nil
}
