package tracking

import (
	"code.justin.tv/hygienic/spade"

	"code.justin.tv/safety/datastore/models"
)

const (
	// aegisReportComment is the spade event name for writing report comments
	aegisReportComment = "aegis_report_comment"
)

// ReportComment is a event for report comment
type ReportComment struct {
	AdminID     int64  `json:"admin_id"`
	CommentID   int64  `json:"comment_id"`
	Environment string `json:"environment"`
	ReportID    int64  `json:"report_id"`
}

// TrackReportComment tracks when an admin adds a report comment
func (c *Client) TrackReportComment(comment models.ReportComment) {
	c.spade.QueueEvents(spade.Event{
		Name: aegisReportComment,
		Properties: ReportComment{
			AdminID:     comment.CreatedBy,
			CommentID:   comment.ID,
			Environment: c.environment,
			ReportID:    comment.ReportID,
		},
	})
}
