package tracking

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	"code.justin.tv/safety/datastore/models"
)

func TestTrackReportComment(t *testing.T) {
	c, s := testClient()

	comment := models.ReportComment{
		CreatedBy: 123,
		ID:        234,
		ReportID:  345,
	}

	c.TrackReportComment(comment)

	events := s.GetEvents()
	require.Equal(t, 1, len(events))
	event := events[0]
	assert.Equal(t, aegisReportComment, event.Name)
	assert.Equal(t, ReportComment{
		AdminID:     comment.CreatedBy,
		CommentID:   comment.ID,
		Environment: testEnvironment,
		ReportID:    comment.ReportID,
	}, event.Properties)
}
