package tracking

import (
	"code.justin.tv/hygienic/spade"

	"code.justin.tv/safety/datastore/models"
)

const (
	// aegisReportHoldCancel is the spade event name for cancelling report hold
	aegisReportHoldCancel = "aegis_hold_cancel"
)

// ReportHoldCancel is an event for cancelling report hold
type ReportHoldCancel struct {
	AdminID         int64  `json:"admin_id"`
	CancelAtSecond  int64  `json:"cancel_at_second"`
	Environment     string `json:"environment"`
	HoldID          int64  `json:"hold_id"`
	RemainingSecond int64  `json:"remaining_second"`
}

// TrackReportHoldCancel tracks when an admin cancels an existing report hold
func (c *Client) TrackReportHoldCancel(hold models.ReportHold, canceledBy int64) {
	c.spade.QueueEvents(spade.Event{
		Name: aegisReportHoldCancel,
		Properties: ReportHoldCancel{
			AdminID:         canceledBy,
			CancelAtSecond:  int64(hold.DisabledAt.Sub(hold.CreatedAt).Seconds()),
			Environment:     c.environment,
			HoldID:          hold.ID,
			RemainingSecond: int64(hold.HoldUntil.Sub(*hold.DisabledAt).Seconds()),
		},
	})
}
