package tracking

import (
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	"code.justin.tv/safety/datastore/models"
)

func TestTrackReportHoldCancel(t *testing.T) {
	c, s := testClient()

	adminID := int64(999)
	canceledAtSeconds := int64(400)
	remainingSeconds := int64(600)

	createdAt := time.Now()
	disabledAt := createdAt.Add(time.Duration(canceledAtSeconds) * time.Second)
	holdUntil := createdAt.Add(time.Duration(canceledAtSeconds+remainingSeconds) * time.Second)

	hold := models.ReportHold{
		ID:         123,
		CreatedAt:  createdAt,
		DisabledAt: &disabledAt,
		HoldUntil:  holdUntil,
	}

	c.TrackReportHoldCancel(hold, adminID)

	events := s.GetEvents()
	require.Equal(t, 1, len(events))
	event := events[0]
	assert.Equal(t, aegisReportHoldCancel, event.Name)
	assert.Equal(t, ReportHoldCancel{
		AdminID:         adminID,
		HoldID:          hold.ID,
		Environment:     testEnvironment,
		CancelAtSecond:  canceledAtSeconds,
		RemainingSecond: remainingSeconds,
	}, event.Properties)
}
