package tracking

import (
	"code.justin.tv/hygienic/spade"

	"code.justin.tv/safety/datastore/models"
)

const (
	// aegisReportHoldCreate is the spade event name for creating report hold
	aegisReportHoldCreate = "aegis_hold_create"
)

// ReportHoldCreate is an event for creating report hold
type ReportHoldCreate struct {
	AdminID     int64  `json:"admin_id"`
	Environment string `json:"environment"`
	HoldID      int64  `json:"hold_id"`
	ReportID    int64  `json:"report_id"`
	SetUpSecond int64  `json:"set_up_second"`
}

// TrackReportHoldCreate tracks when an admin creates a new report hold
func (c *Client) TrackReportHoldCreate(hold models.ReportHold) {
	c.spade.QueueEvents(spade.Event{
		Name: aegisReportHoldCreate,
		Properties: ReportHoldCreate{
			AdminID:     hold.CreatedBy,
			Environment: c.environment,
			SetUpSecond: int64(hold.HoldUntil.Sub(hold.CreatedAt).Seconds()),
			HoldID:      hold.ID,
			ReportID:    hold.ReportID,
		},
	})
}
