package tracking

import (
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	"code.justin.tv/safety/datastore/models"
)

func TestTrackReportHoldCreate(t *testing.T) {
	c, s := testClient()

	adminID := int64(999)
	totalDuration := int64(1000)

	createdAt := time.Now()
	holdUntil := createdAt.Add(time.Duration(totalDuration) * time.Second)

	hold := models.ReportHold{
		ID:        123,
		CreatedBy: adminID,
		CreatedAt: createdAt,
		HoldUntil: holdUntil,
		ReportID:  34324,
	}

	c.TrackReportHoldCreate(hold)

	events := s.GetEvents()
	require.Equal(t, 1, len(events))
	event := events[0]
	assert.Equal(t, aegisReportHoldCreate, event.Name)
	assert.Equal(t, ReportHoldCreate{
		AdminID:     adminID,
		HoldID:      hold.ID,
		Environment: testEnvironment,
		SetUpSecond: totalDuration,
		ReportID:    hold.ReportID,
	}, event.Properties)
}
