package tracking

import (
	"testing"

	shiftmodel "code.justin.tv/safety/datastore/models/shift"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	"code.justin.tv/safety/datastore/models"
)

func TestTrackShiftOn(t *testing.T) {
	c, s := testClient()

	shift := models.Shift{
		ID:      "id",
		AdminID: 123,
		Type:    shiftmodel.Main,
		Weight:  987,
	}

	c.TrackShiftOn(shift)

	events := s.GetEvents()
	require.Equal(t, 1, len(events))
	event := events[0]
	assert.Equal(t, aegisShiftChange, event.Name)
	assert.Equal(t, ShiftChange{
		Action:      shiftActionOn,
		AdminID:     shift.AdminID,
		ChangedBy:   shift.AdminID,
		Environment: testEnvironment,
		RoleType:    string(shiftmodel.Main),
		Weight:      shift.Weight,
	}, event.Properties)
}

func TestTrackShiftChangeWeight(t *testing.T) {
	c, s := testClient()

	changedBy := int64(456)
	shift := models.Shift{
		ID:      "id",
		AdminID: 123,
		Type:    shiftmodel.Main,
		Weight:  987,
	}

	c.TrackShiftChangeWeight(shift, changedBy)

	events := s.GetEvents()
	require.Equal(t, 1, len(events))
	event := events[0]
	assert.Equal(t, aegisShiftChange, event.Name)
	assert.Equal(t, ShiftChange{
		Action:      shiftActionChangeWeight,
		AdminID:     shift.AdminID,
		ChangedBy:   changedBy,
		Environment: testEnvironment,
		RoleType:    string(shiftmodel.Main),
		Weight:      shift.Weight,
	}, event.Properties)
}

func TestTrackShiftOff(t *testing.T) {
	c, s := testClient()

	changedBy := int64(456)
	shift := models.Shift{
		ID:      "id",
		AdminID: 123,
		Type:    shiftmodel.Main,
		Weight:  987,
	}

	c.TrackShiftOff(shift, changedBy)

	events := s.GetEvents()
	require.Equal(t, 1, len(events))
	event := events[0]
	assert.Equal(t, aegisShiftChange, event.Name)
	assert.Equal(t, ShiftChange{
		Action:      shiftActionOff,
		AdminID:     shift.AdminID,
		ChangedBy:   changedBy,
		Environment: testEnvironment,
		RoleType:    string(shiftmodel.Main),
		Weight:      shift.Weight,
	}, event.Properties)
}
