import javaposse.jobdsl.dsl.helpers.step.*

StepContext.metaClass.withBuilder = { String command ->
    shell """
            docker run \
                -v \$KUBECONFIG:/root/.kube/config \
                -v \$PWD/out:/out \
                -e AWS_ACCESS_KEY_ID \
                -e AWS_SECRET_ACCESS_KEY \
                docker.internal.justin.tv/safety/builder:latest \
                ${command}
    """
}

job {
    name 'safety-aegis-deploy'
    using 'TEMPLATE-deploy'

    wrappers {
        credentialsBinding {
            file 'KUBECONFIG', 'safety-kubeconfig-prod'
            file 'COURIERD_PRIVATE_KEY', 'courierd'
            string 'AWS_ACCESS_KEY_ID', 'twitch_safety_deployment_access_key'
            string 'AWS_SECRET_ACCESS_KEY', 'twitch_safety_deployment_secret_key'
        }
    }

    steps {
        shell """
                # Pull yaml files for deployment
                aws s3 cp --region us-west-2 --recursive s3://twitch-safety-deployment/safety/aegis/build/\$GIT_COMMIT out

                # Pull builder docker container
                docker pull docker.internal.justin.tv/safety/builder:latest
        """
        withBuilder '/scripts/prod-deploy.sh'
    }
}
