"use strict";

// Do this as the first thing so that any code reading it knows the right env.
process.env.BABEL_ENV = "test";
process.env.NODE_ENV = "test";
process.env.PUBLIC_URL = "";

// Makes the script crash on unhandled rejections instead of silently
// ignoring them. In the future, promise rejections that are not handled will
// terminate the Node.js process with a non-zero exit code.
process.on("unhandledRejection", err => {
  throw err;
});

// Ensure environment variables are read.
require("../config/env");

const jest = require("jest");
const argv = process.argv.slice(2);

// Watch unless on CI or in coverage mode
if (argv.indexOf("--ci") < 0 && argv.indexOf("--coverage") < 0) {
  argv.push("--watch");
}

if (process.env.TEST_MODE === "integration") {
  process.env.AEGIS_TEST_USER_NAME = process.env.AEGIS_TEST_USER_NAME || "srvc-safety-staging";

  if (!process.env.AEGIS_TEST_USER_PASSWORD) {
    throw new Error("password is not set");
  }
  // Set default values for integration test
  if (!process.env.TEST_HOST) {
    process.env.TEST_HOST = "http://aegis.localhost.justin.tv:3000";
    process.env.TEST_SERVER = "http://aegis.localhost.justin.tv:8001";
    process.env.TEST_DOMAIN = "aegis.localhost.justin.tv";
  } else {
    process.env.TEST_DOMAIN = process.env.TEST_HOST;

    if (!process.env.TEST_HOST.startsWith("http://") && !process.env.TEST_HOST.startsWith("https://")) {
      process.env.TEST_HOST = "http://" + process.env.TEST_HOST;
    }
    // Turns aegis-pr-xxx.service.safety-staging.justin.tv into
    // aegis-pr-xxx-testserver.service.safety-staging.justin.tv
    const parts = process.env.TEST_HOST.split(".");
    process.env.TEST_SERVER = parts[0] + "-testserver." + parts.slice(1).join(".");
  }

  console.log("running integration tests with following settings:");
  console.log(`TEST_HOST=${process.env.TEST_HOST}`);
  console.log(`TEST_SERVER=${process.env.TEST_SERVER}`);
  console.log(`TEST_DOMAIN=${process.env.TEST_DOMAIN}`);
  // Override the test match so we only run the integration tests
  argv.push("--testMatch=<rootDir>src/integration/**/?(*.)(spec|test).ts?(x)");
  argv.push(`--testURL=${process.env.TEST_SERVER}`);
} else {
  console.log("running unit tests");

  process.env.TEST_MODE = "unit";
  // Ignore integration tests
  argv.push("--testPathIgnorePatterns=src/integration/*");
}
jest.run(argv);
