import * as React from "react";

import { createContext } from "aegis/functionality/utils/contrib/twilight/context";

// AncestorNameContext provides the name of closest ancestor
export interface AncestorNameContext {
  ancestorName: AncestorName;
}

export const AncestorNameDataAttribute = "data-context-ancestor-name";

export enum AncestorName {
  CollapsedReportCard = "collapsed_report_card",
  HoldDropdown = "hold_dropdown",
  ImageUploader = "image_uploader",
  InvestigativeQueueModal = "investigative_queue_modal",
  ReassignDropdown = "reassign_dropdown",
  ReportCard = "report_card",
  ResolveDropdown = "resolve_dropdown",
  Root = "root",
  ScreenshotModal = "screenshot_modal",
  StrikeModal = "strike_modal",
  UserCard = "user_card"
}

const initValues: AncestorNameContext = {
  ancestorName: AncestorName.Root
};

export const { InnerProvider, withContext: withAncestorNameContext } = createContext<AncestorNameContext>(
  "AncestorNameContext",
  initValues
);

export class AncestorNameContextProvider extends React.Component<AncestorNameContext> {
  public render() {
    return (
      <InnerProvider value={this.props}>
        <div data-context-ancestor-name={this.props.ancestorName}>{this.props.children}</div>
      </InnerProvider>
    );
  }
}

export const AncestorNameContextMapper = function mapContextToProps(context: AncestorNameContext): AncestorNameContext {
  return context;
};
