import * as React from "react";

import { Report } from "aegis/features/reports";
import { createContext } from "aegis/functionality/utils/contrib/twilight/context";

export interface ReportQueueActionContext {
  onAutoResolve?: () => void;
  onCancelHold?: (report: Report) => void;
}

const initValues: ReportQueueActionContext = {};

export const { InnerProvider, withContext: withReportQueueActionContext } = createContext<ReportQueueActionContext>(
  "ReportQueueActionsContext",
  initValues
);

export class ReportQueueActionContextProvider extends React.Component<ReportQueueActionContext> {
  public render() {
    return <InnerProvider value={this.props}>{this.props.children}</InnerProvider>;
  }
}
