import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { FETCH_CHAT_LOGS_QUERY } from "aegis/features/chatlogs";
import { UserQuery } from "aegis/features/user";
import * as stores from "aegis/stores";
import { wrapWithGQLProvider } from "aegis/tests/graphql";
import App from "./App";

const apolloMocks = [
  {
    request: {
      query: UserQuery,
      variables: {
        id: "17089325"
      }
    },
    result: {
      data: {
        user: {
          id: "17089325",
          login: "3v",
          isBanned: false,
          isDMCABanned: false,
          isDeleted: false,
          language: "fi",
          displayName: "3v",
          profileImage: "https://static-cdn.jtvnw.net/jtv_user_pictures/3v-profile_image-aaa5f1b8946fa6b9-600x600.png",
          type: "staff",
          __typename: "User"
        }
      }
    }
  },
  {
    request: {
      query: FETCH_CHAT_LOGS_QUERY,
      variables: {
        users: ["17089325"],
        first: 1,
        after: ""
      }
    },
    result: {
      data: {
        chatentries: {
          edges: [
            {
              node: {
                id: "03732770-9032-4006-8e54-2906bf1df2f0",
                timestamp: "2018-01-23 17:19:03.781",
                type: "usernotice",
                channel: {
                  id: "31903352",
                  login: "tehzomb",
                  isBanned: false,
                  isDMCABanned: false,
                  isDeleted: false,
                  language: "en",
                  displayName: "TehZomb",
                  profileImage:
                    "https://static-cdn.jtvnw.net/jtv_user_pictures/tehzomb-profile_image-cc7e5d66292c36c8-600x600.png",
                  type: "",
                  __typename: "User"
                },
                user: {
                  id: "17089325",
                  login: "3v",
                  isBanned: false,
                  isDMCABanned: false,
                  isDeleted: false,
                  language: "fi",
                  displayName: "3v",
                  profileImage:
                    "https://static-cdn.jtvnw.net/jtv_user_pictures/3v-profile_image-aaa5f1b8946fa6b9-600x600.png",
                  type: "staff",
                  __typename: "User"
                },
                message: "zombHey"
              },
              cursor: "2018-01-23 17:19:03.781"
            }
          ],
          pageInfo: {
            startCursor: "{}",
            endCursor: "{}",
            hasNextPage: true,
            hasPreviousPage: false
          }
        }
      }
    }
  }
];

Enzyme.configure({ adapter: new Adapter() });

const setup = () => {
  return Enzyme.mount(wrapWithGQLProvider(<App />, apolloMocks).wrappedComponent);
};

describe("App ", () => {
  it("renders ", () => {
    window.fetch = jest.fn().mockImplementation(() => {
      return new Promise(resolve => {
        resolve({
          ok: true,
          json: function() {
            return { location: "https://twitch.tv" };
          }
        });
      });
    });

    const wrapper = setup();

    expect(wrapper.find(App)).toHaveLength(1);
    expect(wrapper.find(".App")).toHaveLength(0);

    // Simulate user login
    stores.authStore.tokenReceived("dummy123");
    wrapper.update();

    expect(wrapper.find(App)).toHaveLength(1);
    expect(wrapper.find(".App")).toHaveLength(1);
  });
});
