import * as React from "react";
import { BrowserRouter as Router, Route } from "react-router-dom";

// External package features
import { ToastContainer, ToastPosition } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";

// Error boundary
import { FallbackProps, withErrorBoundary } from "react-error-boundary";

// Features
import { Themer } from "aegis/features/themer";
import { TopNav } from "aegis/features/topnav";

// Functionality
import { ModalRoot } from "aegis/functionality/components/modal-root";
import { PortalModalRoot } from "aegis/functionality/components/portal-modal";

// Pages
import { AccountInfoPage } from "aegis/pages/account-info";
import { AltUserLookup } from "aegis/pages/altlookup";
import { BanFormPage } from "aegis/pages/banform";
import { BountiesPage } from "aegis/pages/bountiespage";
import { ChatActivityPage } from "aegis/pages/chatactivitypage";
import { ChatPage } from "aegis/pages/chatpage";
import { ClipsMassDeleter } from "aegis/pages/clips-mass-deleter";
import { EmoteApprovalPage } from "aegis/pages/emoteapproval";
import { EnforcementPage } from "aegis/pages/enforcement-search";
import { GameDirectoryPage } from "aegis/pages/game-directory";
import { HomePage } from "aegis/pages/homepage";
import { ImageUploadPage } from "aegis/pages/image-upload";
import { LoginImposer } from "aegis/pages/loginimposer";
import { MainContent } from "aegis/pages/maincontent";
import { PartnerEscalationPage } from "aegis/pages/partner-escalation-list";
import { ReportSearchPage } from "aegis/pages/report-search";
import { ReportDetailPage } from "aegis/pages/reportdetailpage";
import { ReportQueuePage } from "aegis/pages/reportqueuepage";

// Tracking
import { ClickTracker, HeartbeatTracker, withTracking } from "aegis/features/tracking";

// Core UI
import { Color, CoreText } from "twitch-core-ui";

// Rollbar
import { RollbarHandler } from "aegis/functionality/rollbar";

import "./App.scss";

class AppComponent extends React.Component {
  render() {
    return (
      <LoginImposer>
        <Themer>
          <div className="App full-height">
            <ModalRoot />
            <PortalModalRoot />
            <HeartbeatTracker />
            <ClickTracker />
            <Router>
              <>
                <TopNav />
                <MainContent />
                <ToastContainer className="toast-container" position={ToastPosition.TOP_CENTER} />
                <Route path="/" exact={true} component={withTracking(HomePage)} />
                <Route path="/accountinfo/:query?" component={withTracking(AccountInfoPage)} />
                <Route path="/altlookup/:query?" component={withTracking(AltUserLookup)} />
                <Route path="/ban/:query?" component={withTracking(BanFormPage)} />
                <Route path="/bounties" component={withTracking(BountiesPage)} />
                <Route path="/chatlogs/:query?" component={withTracking(ChatPage)} />
                <Route path="/chatactivity/:query?" component={withTracking(ChatActivityPage)} />
                <Route path="/clips/deleter" exact={true} component={withTracking(ClipsMassDeleter)} />
                <Route path="/emoticons" exact={true} component={withTracking(EmoteApprovalPage)} />
                <Route path="/enforcementsearch/:query?" component={withTracking(EnforcementPage)} />
                <Route path="/gamedirectory/:query?" component={withTracking(GameDirectoryPage)} />
                <Route path="/imageupload" exact={true} component={withTracking(ImageUploadPage)} />
                <Route path="/partnerescalation/:query?" component={withTracking(PartnerEscalationPage)} />
                <Route path="/report/:query?" component={withTracking(ReportDetailPage)} />
                <Route path="/reportsearch/:query?" component={withTracking(ReportSearchPage)} />
                <Route path="/workspaces/:query?" component={withTracking(ReportQueuePage)} />
              </>
            </Router>
          </div>
        </Themer>
      </LoginImposer>
    );
  }
}

const FallbackApp: React.SFC<FallbackProps> = props => (
  <RollbarHandler {...props} componentName="App">
    <CoreText color={Color.Error}>An unrecoverable error occurred. Please refresh the page.</CoreText>
    <CoreText color={Color.Error}>
      The Safety Dev team has been notified, but please notify your Shift Leader to page us if this continues to occur
      and/or is severely impacting your work.
    </CoreText>
  </RollbarHandler>
);

const App = withErrorBoundary(AppComponent, FallbackApp);

export default App;
