import * as React from "react";

import { Column, Display, FlexDirection, Grid, Layout, LoadingSpinner } from "twitch-core-ui";

import { DetailedUser } from "aegis/models";
import { AccountInfoBody } from "./components/body";
import { AccountInfoDeleteContextProvider } from "./components/common/delete-content";
import { DeleteBar } from "./components/common/delete-content/delete-bar";
import { AccountInfoHeader } from "./components/header";
import { AccountInfoSearch } from "./components/search";
import { AccountInfoSidebar } from "./components/sidebar";

export interface PublicProps {
  user?: DetailedUser;
  loading?: boolean;
  id?: string;
}

export class AccountInfoComponent extends React.Component<PublicProps> {
  public render() {
    const { loading, user, id } = this.props;
    return (
      <Layout fullWidth display={Display.Flex} flexDirection={FlexDirection.Column} padding={2}>
        <AccountInfoSearch defaultID={id} />
        {user && !loading && <AccountInfoContent user={user} />}
        {loading && <LoadingSpinner />}
      </Layout>
    );
  }
}

const AccountInfoContent: React.SFC<{ user: DetailedUser }> = ({ user }) => {
  return (
    <AccountInfoDeleteContextProvider user={user}>
      <Grid>
        <Column cols={10}>
          <AccountInfoHeader user={user} />
        </Column>
      </Grid>
      <Grid>
        <Column cols={10}>
          <AccountInfoBody user={user} />
        </Column>
        <Column cols={2}>
          <AccountInfoSidebar user={user} />
        </Column>
      </Grid>
      <DeleteBar user={user} />
    </AccountInfoDeleteContextProvider>
  );
};
