import * as React from "react";

import {
  AlignItems,
  ChannelStatusIndicator,
  ChannelStatusIndicatorStatus,
  Color,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  Layout,
  Stat,
  SVGAsset
} from "twitch-core-ui";

import { DetailedUser } from "aegis/models";

import { formatDurationTimestamp } from "aegis/features/report-view/components/report-body/stream-embed/component";
import "./styles.scss";

export interface PublicProps {
  user: DetailedUser;
}

export class AccountInfoChannelStreamInfo extends React.Component<PublicProps> {
  public render() {
    const { user } = this.props;
    const { stream, channel } = user;
    if (!channel) {
      return (
        <Layout padding={{ y: 1 }}>
          <CoreText fontSize={FontSize.Size5}>Unable to fetch channel info</CoreText>
        </Layout>
      );
    }
    return (
      <Layout display={Display.Flex} flexDirection={FlexDirection.Column}>
        <Layout padding={{ top: 2 }}>
          <CoreText fontSize={FontSize.Size5} color={Color.Alt2}>
            Stream Title
          </CoreText>
          <CoreText fontSize={FontSize.Size5} bold>
            {channel.title}
          </CoreText>
        </Layout>
        <Layout padding={{ y: 1 }}>
          <CoreText fontSize={FontSize.Size5} color={Color.Alt2}>
            Category
          </CoreText>
          <CoreText fontSize={FontSize.Size5}>{channel && channel.game}</CoreText>
        </Layout>
        <Layout padding={{ y: 1 }}>
          <CoreText fontSize={FontSize.Size5} color={Color.Alt2}>
            Mature Content Warning
          </CoreText>
          <CoreText fontSize={FontSize.Size5}>{channel && channel.mature ? "Yes" : "No"}</CoreText>
        </Layout>
        {stream && (
          <>
            <Layout padding={{ top: 2 }} display={Display.Flex} alignItems={AlignItems.Center}>
              <Layout padding={{ right: 3, bottom: 0.5 }}>
                <Layout className="tw-stat">
                  <span className="tw-stat__icon">
                    <ChannelStatusIndicator status={ChannelStatusIndicatorStatus.Live} />
                  </span>
                  <span className="tw-stat__value">Live now</span>
                </Layout>
              </Layout>
              <Layout padding={{ right: 3 }}>
                <Stat icon={SVGAsset.NavProfile} value={stream.viewCount.toString()} label="View count" />
              </Layout>
              <Layout>
                <Stat
                  icon={SVGAsset.Timeout}
                  value={"has been streaming " + formatDurationTimestamp(stream.duration)}
                  label="Duration"
                />
              </Layout>
            </Layout>
            <Layout className="channel-stream-info-embed">
              <iframe src={user.streamEmbedURL} allowFullScreen />
            </Layout>
          </>
        )}
      </Layout>
    );
  }
}
