import * as React from "react";

import * as Enzyme from "enzyme";
import { shallow } from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { createHistory } from "aegis/functionality/utils/contrib/twilight/history";
import { MockDetailedUser } from "aegis/models/mocks";
import { Tabs } from "twitch-core-ui";
import { AccountInfoBodyComponent, Props, TestSelectors } from "./component";
import { AccountInfoEnforcementHistory } from "./enforcement-history";
import { AccountInfoTabs, InfoTab } from "./tabs";

Enzyme.configure({ adapter: new Adapter() });

const defaultPropsGenerator = (overrides?: Partial<Props>): Props => {
  return {
    user: MockDetailedUser({ id: "userID" }),
    history: createHistory(true),
    location: { search: "?id=userID&tabID=" + InfoTab.Profile },
    ...overrides
  } as Props;
};

const setup = (overrides?: Partial<Props>) => {
  const props = defaultPropsGenerator(overrides);
  return { props, wrapper: shallow(<AccountInfoBodyComponent {...props} />) };
};

describe("AccountInfoComponent", () => {
  it("renders with body with valid tab in url", () => {
    const { props, wrapper } = setup();

    expect(props.history.length).toBe(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.PopulatedBody }).length).toBeGreaterThan(0);
  });

  it("renders empty and redirects when invalid tab in URL", () => {
    const { props, wrapper } = setup({ location: { search: "", pathname: "", state: "", hash: "" } });

    expect(wrapper.html()).toBe(null);
    expect(props.history.length).toBe(2);
  });

  it("pushes to history when tab is changed", () => {
    const { props, wrapper } = setup();

    expect(props.history.length).toBe(1);

    // Clicks a different tab
    wrapper
      .find(AccountInfoTabs)
      .dive()
      .find(Tabs)
      .dive()
      .find({ "data-test-selector": InfoTab.EnforcementHistory })
      .simulate("click");

    expect(props.history.length).toBe(2);
  });

  it("renders correct tab when non-default tab is selected", () => {
    const { wrapper } = setup({
      location: { search: "?tabID=" + InfoTab.EnforcementHistory, pathname: "", state: "", hash: "" }
    });

    const currentBody = wrapper.find({ "data-test-selector": TestSelectors.BodyContent }).dive();

    expect(currentBody.find(AccountInfoEnforcementHistory).length).toBeGreaterThan(0);
  });
});
