import * as React from "react";

import { DeletableTypes, DeleteTick } from "aegis/features/account-info/components/common/delete-content";
import {
  Color,
  CoreImage,
  CoreLink,
  CoreText,
  Display,
  FlexDirection,
  Layout,
  TextType,
  Tooltip
} from "twitch-core-ui";

export interface Props {
  url?: string;
  className?: string;
  title: string;
  contentID: string;
}

export enum TestSelectors {
  DeleteImage = "channel-image--delete-image",
  Image = "channel-image--image"
}

export const ChannelImage: React.SFC<Props> = ({ url, className, title, contentID }) => {
  let imageNode: React.ReactNode;

  if (!url) {
    imageNode = (
      <CoreText type={TextType.Em} color={Color.Alt2}>
        No {title.toLowerCase()}
      </CoreText>
    );
  } else {
    imageNode = (
      <>
        <Tooltip label="Open in full size">
          <CoreLink linkTo={url} targetBlank>
            <CoreImage
              src={url}
              alt={title}
              className={className}
              data-test-selector={`${TestSelectors.Image}--${contentID}`}
            />
          </CoreLink>
        </Tooltip>
        <DeleteTick
          contentIDs={[contentID]}
          contentType={DeletableTypes.ChannelImages}
          label={title}
          data-test-selector={TestSelectors.DeleteImage}
        />
      </>
    );
  }

  return (
    <Layout display={Display.Flex} flexDirection={FlexDirection.Column}>
      <Layout padding={1}>{imageNode}</Layout>
    </Layout>
  );
};
