import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockDetailedUser } from "aegis/models/mocks";
import { MemoryRouter } from "react-router";
import { AccountInfoDeleteContextProvider } from "../../../common/delete-content";
import { TestSelectors as ChannelImageTestSelectors } from "./channel-image";
import { ChannelImages, ChannelImageTypes, Props, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

const setupMount = (overrides?: Partial<Props>) => {
  const props: Props = {
    ...overrides
  };

  return Enzyme.mount(
    <MemoryRouter>
      <AccountInfoDeleteContextProvider user={MockDetailedUser()}>
        <ChannelImages {...props} />
      </AccountInfoDeleteContextProvider>
    </MemoryRouter>
  );
};

const profileImage = "profile-image";
const profileBanner = "profile-banner";
const offlineImage = "offline-image";

describe("ChannelImages", () => {
  it("renders with no images", () => {
    const wrapper = setupMount();
    expect(wrapper.find({ "data-test-selector": TestSelectors.SelectAllChannelImages })).toHaveLength(2);
    expect(wrapper.find({ "data-test-selector": ChannelImageTestSelectors.DeleteImage })).toHaveLength(0);
  });

  it("renders with all images", () => {
    const wrapper = setupMount({
      profileImageURL: profileImage,
      profileBannerURL: profileBanner,
      offlineImageURL: offlineImage
    });
    expect(wrapper.find({ "data-test-selector": TestSelectors.SelectAllChannelImages })).toHaveLength(2);
    expect(wrapper.find({ "data-test-selector": ChannelImageTestSelectors.DeleteImage })).toHaveLength(6);

    const image = wrapper
      .find({ "data-test-selector": `${ChannelImageTestSelectors.Image}--${ChannelImageTypes.ProfileImage}` })
      .first();

    expect(image.prop("src")).toBe(profileImage);
  });
});
