import * as React from "react";

import { DeletableTypes, DeleteTick } from "aegis/features/account-info/components/common/delete-content";
import { HeaderTitle } from "aegis/functionality/components/header-title";
import { Display, Layout } from "twitch-core-ui";
import { ChannelImage } from "./channel-image";

export interface Props {
  profileImageURL?: string;
  profileBannerURL?: string;
  offlineImageURL?: string;
}

export enum ChannelImageTypes {
  ProfileImage = "profile-image",
  ProfileBanner = "profile-banner",
  OfflineImage = "offline-image"
}

const AllChannelImageTypes = [
  ChannelImageTypes.ProfileImage,
  ChannelImageTypes.ProfileBanner,
  ChannelImageTypes.OfflineImage
];

export enum TestSelectors {
  SelectAllChannelImages = "channel-images--select-all"
}

export const ChannelImages: React.SFC<Props> = ({ profileImageURL, profileBannerURL, offlineImageURL }) => {
  const imageClass = "account-info--profile-image";
  return (
    <>
      <HeaderTitle title="Channel images">
        <DeleteTick
          contentIDs={AllChannelImageTypes}
          contentType={DeletableTypes.ChannelImages}
          data-test-selector={TestSelectors.SelectAllChannelImages}
        />
      </HeaderTitle>
      <Layout padding={2} display={Display.Flex}>
        <ChannelImage
          url={profileImageURL}
          title="Profile image"
          className={imageClass}
          contentID={ChannelImageTypes.ProfileImage}
        />
        <ChannelImage
          url={profileBannerURL}
          title="Profile banner"
          className={imageClass}
          contentID={ChannelImageTypes.ProfileBanner}
        />
        <ChannelImage
          url={offlineImageURL}
          title="Offline image"
          className={imageClass}
          contentID={ChannelImageTypes.OfflineImage}
        />
      </Layout>
    </>
  );
};
