import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { ChatRules, PublicProps, TestSelectors } from "./component";

Enzyme.configure({ adapter: new Adapter() });

describe("ChatRules", () => {
  const setupShallow = (override?: Partial<PublicProps>) => {
    const props: PublicProps = {
      chatRules: [],
      ...override
    };
    return Enzyme.shallow(<ChatRules {...props} />);
  };

  it("renders with no chat rules", () => {
    const wrapper = setupShallow();
    expect(wrapper.find({ "data-test-selector": TestSelectors.NotSet })).toHaveLength(1);
    expect(wrapper.find({ "data-test-selector": TestSelectors.ChatRule })).toHaveLength(0);
  });

  it("renders with chat rules", () => {
    const wrapper = setupShallow({
      chatRules: ["rule 1", "rule 2"]
    });
    expect(wrapper.find({ "data-test-selector": TestSelectors.NotSet })).toHaveLength(0);
    expect(wrapper.find({ "data-test-selector": TestSelectors.ChatRule })).toHaveLength(2);
  });
});
