import * as React from "react";

import { DeletableTypes, DeleteTick } from "aegis/features/account-info/components/common/delete-content";
import { HeaderTitle } from "aegis/functionality/components/header-title";
import { Color, CoreText, Layout, TextType } from "twitch-core-ui";

export interface PublicProps {
  chatRules?: string[];
}

export enum TestSelectors {
  ChatRule = "account-info-profile--chat-rule",
  NotSet = "account-info-profile--not-set"
}

export const ChatRules: React.SFC<PublicProps> = ({ chatRules }) => {
  let rules: React.ReactNode;

  if (!chatRules) {
    rules = (
      <CoreText type={TextType.Em} color={Color.Error}>
        Failed to load chat rules
      </CoreText>
    );
  } else if (chatRules.length === 0) {
    rules = (
      <CoreText type={TextType.Em} color={Color.Alt2} data-test-selector={TestSelectors.NotSet}>
        Not set
      </CoreText>
    );
  } else {
    rules = chatRules.map(rule => (
      <CoreText key={rule} data-test-selector={TestSelectors.ChatRule}>
        {rule}
      </CoreText>
    ));
  }

  return (
    <>
      <HeaderTitle title="Chat rules">
        <DeleteTick contentIDs={["all"]} contentType={DeletableTypes.ChatRule} />
      </HeaderTitle>
      <Layout padding={1}>{rules}</Layout>
    </>
  );
};
