import * as React from "react";

import * as Enzyme from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockDetailedUser } from "aegis/models/mocks";
import { AccountInfoProfileComponent, PublicProps } from "./component";
import { UserEmoticons } from "./user-emoticons";

Enzyme.configure({ adapter: new Adapter() });

describe("account-info profile", () => {
  const setupShallow = (override?: Partial<PublicProps>) => {
    const props: PublicProps = {
      user: MockDetailedUser(),
      profileData: {
        chatRules: [],
        description: "",
        profileImage: ""
      },
      ...override
    };
    return Enzyme.shallow(<AccountInfoProfileComponent {...props} />);
  };

  it("renders", () => {
    const wrapper = setupShallow();
    expect(wrapper.find(UserEmoticons)).toBeTruthy();
  });
});
