import * as React from "react";

import { DetailedUser } from "aegis/models";
import { Layout } from "twitch-core-ui";
import { ChannelImages } from "./channel-images";
import { ChatRules } from "./chat-rules";
import { ProfileData } from "./models";
import { Panels } from "./panels";
import { UserBadges } from "./user-badges";
import { UserDescription } from "./user-description";
import { UserEmoticons } from "./user-emoticons";

import "./styles.scss";

export interface PublicProps {
  user: DetailedUser;
  profileData: ProfileData;
}

export class AccountInfoProfileComponent extends React.Component<PublicProps> {
  public render() {
    const { user, profileData } = this.props;

    return (
      <Layout padding={{ left: 2, top: 2 }}>
        <UserDescription description={profileData.description} />
        <ChannelImages
          profileImageURL={profileData.profileImage}
          profileBannerURL={profileData.channel && profileData.channel.profileBannerImage}
          offlineImageURL={profileData.channel && profileData.channel.offlineImage}
        />
        <ChatRules chatRules={profileData.chatRules} />
        <UserEmoticons emoticons={profileData.emoticons} />
        <UserBadges badges={profileData.badges} />
        <Panels user={user} panels={profileData.panels} />
      </Layout>
    );
  }
}
