import * as React from "react";

import * as Enzyme from "enzyme";
import { shallow } from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockDetailedUser, MockPanel } from "aegis/models/mocks";
import { Panels, Props, TestSelector } from "./component";

Enzyme.configure({ adapter: new Adapter() });

const setupShallow = (overrides?: Partial<Props>) => {
  const props: Props = {
    user: MockDetailedUser(),
    panels: [],
    ...overrides
  };

  return shallow(<Panels {...props} />);
};

describe("PanelsComponent", () => {
  it("renders with no panels", () => {
    const wrapper = setupShallow();

    expect(wrapper.find({ "data-test-selector": TestSelector.DashboardButton })).toHaveLength(0);
    expect(wrapper.find({ "data-test-selector": TestSelector.Panel })).toHaveLength(0);
    expect(wrapper.find({ "data-test-selector": TestSelector.PanelImage })).toHaveLength(0);
  });

  it("renders with multiple panels", () => {
    const wrapper = setupShallow({
      panels: [MockPanel({ id: "1" }), MockPanel({ id: "2" })]
    });

    expect(wrapper.find({ "data-test-selector": TestSelector.DashboardButton })).toHaveLength(1);
    expect(wrapper.find({ "data-test-selector": TestSelector.Panel })).toHaveLength(2);
    expect(wrapper.find({ "data-test-selector": TestSelector.PanelImage })).toHaveLength(2);
  });

  it("renders does not render image with text only panels", () => {
    const wrapper = setupShallow({
      panels: [
        MockPanel({
          imageURL: undefined
        })
      ]
    });

    expect(wrapper.find({ "data-test-selector": TestSelector.DashboardButton })).toHaveLength(1);
    expect(wrapper.find({ "data-test-selector": TestSelector.Panel })).toHaveLength(1);
    expect(wrapper.find({ "data-test-selector": TestSelector.PanelImage })).toHaveLength(0);
  });

  it("renders image with image panels", () => {
    const wrapper = setupShallow({
      panels: [
        MockPanel({
          imageURL: "some image url"
        })
      ]
    });

    expect(wrapper.find({ "data-test-selector": TestSelector.DashboardButton })).toHaveLength(1);
    expect(wrapper.find({ "data-test-selector": TestSelector.Panel })).toHaveLength(1);
    expect(wrapper.find({ "data-test-selector": TestSelector.PanelImage })).toHaveLength(1);
  });
});
