import * as React from "react";

import {
  Color,
  CoreImage,
  CoreText,
  Display,
  FlexDirection,
  FlexWrap,
  Layout,
  Position,
  StyledLayout,
  TextType,
  Tooltip
} from "twitch-core-ui";

import { DeletableTypes, DeleteTick } from "aegis/features/account-info/components/common/delete-content";
import { HeaderTitle } from "aegis/functionality/components/header-title";
import { UserBadge } from "aegis/models";

import "./styles.scss";

export interface Props {
  badges?: UserBadge[];
}

export enum TestSelector {
  UserBadge = "user-badges",
  UserBadgeImage = "user-badges-image",
  SelectBadge = "select-badges",
  SelectAllBadges = "select-all-badges-button",
  EmptyBadgesText = "empty-badges"
}

export const UserBadges = (props: Props) => {
  const { badges } = props;

  const badgeIDs: string[] = [];

  const userBadges =
    badges &&
    badges.length > 0 &&
    badges.map(({ id, largeImageURL, title }) => {
      badgeIDs.push(id);

      return (
        <StyledLayout
          key={id}
          display={Display.Flex}
          flexDirection={FlexDirection.Column}
          margin={{ right: 1, bottom: 1 }}
          padding={0.5}
          data-test-selector={TestSelector.UserBadge}
          position={Position.Relative}
        >
          <Layout>
            <Tooltip display={Display.Inline} key={title} label={title}>
              <CoreImage alt={title} src={largeImageURL} className="account-info-badge__image" />
            </Tooltip>
          </Layout>
          <Layout margin={{ top: 2, bottom: 1 }}>
            <DeleteTick
              contentIDs={[id]}
              contentType={DeletableTypes.Badges}
              label={title}
              data-test-selector={TestSelector.SelectBadge}
            />
          </Layout>
        </StyledLayout>
      );
    });

  const content = (userBadges && (
    <Layout display={Display.Flex} flexWrap={FlexWrap.Wrap}>
      {userBadges}
    </Layout>
  )) || (
    <CoreText type={TextType.Em} color={Color.Alt2} data-test-selector={TestSelector.EmptyBadgesText}>
      No badges
    </CoreText>
  );

  return (
    <Layout fullWidth display={Display.Flex} flexDirection={FlexDirection.Column}>
      <HeaderTitle title="Channel Badges">
        <DeleteTick
          contentIDs={badgeIDs}
          contentType={DeletableTypes.Badges}
          data-test-selector={TestSelector.SelectAllBadges}
        />
      </HeaderTitle>
      <Layout padding={1}>{content}</Layout>
    </Layout>
  );
};
