import * as React from "react";

import { DeletableTypes, DeleteTick } from "aegis/features/account-info/components/common/delete-content";
import { HeaderTitle } from "aegis/functionality/components/header-title";
import { Color, CoreText, Layout, TextType } from "twitch-core-ui";

export interface Props {
  description: string;
}

export const UserDescription: React.SFC<Props> = ({ description }) => {
  let descNode: React.ReactNode;

  if (!description) {
    descNode = (
      <CoreText type={TextType.Em} color={Color.Alt2}>
        No description
      </CoreText>
    );
  } else {
    descNode = <CoreText>{description}</CoreText>;
  }

  return (
    <>
      <HeaderTitle title="Description">
        <DeleteTick contentIDs={["all"]} contentType={DeletableTypes.Description} />
      </HeaderTitle>
      <Layout padding={1}>{descNode}</Layout>
    </>
  );
};
