import * as React from "react";

import * as Enzyme from "enzyme";
import { mount } from "enzyme";
import * as Adapter from "enzyme-adapter-react-16";

import { MockDetailedUser } from "aegis/models/mocks";
import { CheckBox } from "twitch-core-ui";
import { AccountInfoDeleteContextProvider } from "../../../common/delete-content";
import { Props, TestSelector, UserEmoticons } from "./component";

Enzyme.configure({ adapter: new Adapter() });

const setupMount = (overrides?: Partial<Props>) => {
  const props: Props = {
    emoticons: [
      {
        id: "<emoticonID-1>",
        code: "<emoticonCode-1>"
      },
      {
        id: "<emoticonID-2>",
        code: "<emoticonCode-2>"
      },
      {
        id: "<emoticonID-3>",
        code: "<emoticonCode-3>"
      }
    ],
    ...overrides
  };

  return mount(
    <AccountInfoDeleteContextProvider user={MockDetailedUser()}>
      <UserEmoticons {...props} />
    </AccountInfoDeleteContextProvider>
  );
};

describe("UserEmoticonsComponent", () => {
  it("renders with no userEmoticons", () => {
    const wrapper = setupMount({ emoticons: [] });

    expect(wrapper.find({ "data-test-selector": TestSelector.UserEmoticon }).hostNodes()).toHaveLength(0);
    expect(wrapper.find({ "data-test-selector": TestSelector.SelectAllEmoticons })).toHaveLength(2);
    expect(wrapper.find({ "data-test-selector": TestSelector.EmptyEmoticonsText }).hostNodes()).toHaveLength(1);
    expect(
      wrapper
        .find({ "data-test-selector": TestSelector.EmptyEmoticonsText })
        .at(0)
        .text()
    ).toEqual("No emotes");
  });

  it("renders with multiple userEmoticons", () => {
    const wrapper = setupMount();

    expect(wrapper.find({ "data-test-selector": TestSelector.UserEmoticon }).hostNodes()).toHaveLength(3);
    expect(wrapper.find({ "data-test-selector": TestSelector.SelectAllEmoticons })).toHaveLength(2);
    expect(wrapper.find({ "data-test-selector": TestSelector.EmptyEmoticonsText }).hostNodes()).toHaveLength(0);
  });

  it("select one emote and updates counter", () => {
    const wrapper = setupMount();

    expect(wrapper.find({ "data-test-selector": TestSelector.UserEmoticon }).hostNodes()).toHaveLength(3);

    wrapper
      .find({ "data-test-selector": TestSelector.SelectEmoticon })
      .first()
      .find(CheckBox)
      .prop("onChange")!({ target: { checked: true } });

    wrapper.update();
    const { checked } = wrapper
      .find({ "data-test-selector": TestSelector.SelectEmoticon })
      .first()
      .find(CheckBox)
      .props();

    expect(wrapper.find({ "data-test-selector": TestSelector.UserEmoticon }).hostNodes()).toHaveLength(3);
    expect(checked).toBeTruthy();
  });

  it("selects all emoticons", () => {
    const wrapper = setupMount();

    expect(wrapper.find({ "data-test-selector": TestSelector.UserEmoticon }).hostNodes()).toHaveLength(3);

    wrapper
      .find({ "data-test-selector": TestSelector.SelectAllEmoticons })
      .last()
      .find(CheckBox)
      .prop("onChange")!({ target: { checked: true } });

    wrapper.update();

    const { checked: firstSelected } = wrapper
      .find({ "data-test-selector": TestSelector.SelectEmoticon })
      .first()
      .find(CheckBox)
      .props();
    const { checked: lastSelected } = wrapper
      .find({ "data-test-selector": TestSelector.SelectEmoticon })
      .last()
      .find(CheckBox)
      .props();

    expect(wrapper.find({ "data-test-selector": TestSelector.UserEmoticon }).hostNodes()).toHaveLength(3);
    expect(firstSelected).toBeTruthy();
    expect(lastSelected).toBeTruthy();
  });
});
