import * as React from "react";

import {
  Color,
  CoreText,
  Display,
  FlexDirection,
  FlexWrap,
  Layout,
  Position,
  StyledLayout,
  TextType
} from "twitch-core-ui";

import { DeletableTypes, DeleteTick } from "aegis/features/account-info/components/common/delete-content";
import { Emote } from "aegis/features/emote";
import { HeaderTitle } from "aegis/functionality/components/header-title";
import { UserEmoticon } from "aegis/models";

import "./styles.scss";

export interface Props {
  emoticons?: UserEmoticon[];
}

export enum TestSelector {
  UserEmoticon = "user-emoticon",
  UserEmoticonImage = "user-emoticon-image",
  SelectEmoticon = "select-emoticon",
  SelectAllEmoticons = "select-all-emoticons-button",
  EmptyEmoticonsText = "empty-emoticons"
}

export const UserEmoticons = (props: Props) => {
  const { emoticons } = props;

  const emoticonIDs: string[] = [];

  const userEmoticons =
    emoticons &&
    emoticons.length > 0 &&
    emoticons.map(({ id, code }) => {
      const composedEmoteID = `${id}/${code}`;
      emoticonIDs.push(composedEmoteID);

      return (
        <StyledLayout
          key={id}
          display={Display.Flex}
          flexDirection={FlexDirection.Column}
          margin={{ right: 1, bottom: 1 }}
          padding={0.5}
          data-test-selector={TestSelector.UserEmoticon}
          position={Position.Relative}
        >
          <div className="account-info-emote__image">
            <Emote
              id={id}
              emoteCode={code}
              version={3}
              displayOverride={Display.Flex}
              data-test-selector={TestSelector.UserEmoticonImage}
            />
          </div>
          <Layout margin={{ top: 2, bottom: 1 }}>
            <DeleteTick
              contentIDs={[composedEmoteID]}
              contentType={DeletableTypes.Emotes}
              label={code}
              data-test-selector={TestSelector.SelectEmoticon}
            />
          </Layout>
        </StyledLayout>
      );
    });

  const content = (userEmoticons && (
    <Layout display={Display.Flex} flexWrap={FlexWrap.Wrap}>
      {userEmoticons}
    </Layout>
  )) || (
    <CoreText type={TextType.Em} color={Color.Alt2} data-test-selector={TestSelector.EmptyEmoticonsText}>
      No emotes
    </CoreText>
  );

  return (
    <Layout fullWidth display={Display.Flex} flexDirection={FlexDirection.Column}>
      <HeaderTitle title="Channel Emotes">
        <DeleteTick
          contentIDs={emoticonIDs}
          contentType={DeletableTypes.Emotes}
          data-test-selector={TestSelector.SelectAllEmoticons}
        />
      </HeaderTitle>
      <Layout padding={1}>{content}</Layout>
    </Layout>
  );
};
