import * as React from "react";

import { TabItemPublicProps, Tabs, TabSize } from "twitch-core-ui";

export enum InfoTab {
  Profile = "Profile",
  ChannelStreamInfo = "ChannelStreamInfo",
  EnforcementHistory = "EnforcementHistory"
}

export const tabsData = [
  { tab: InfoTab.Profile, label: "Profile" },
  { tab: InfoTab.ChannelStreamInfo, label: "Channel Stream Info" },
  { tab: InfoTab.EnforcementHistory, label: "Enforcement History" }
];

export interface PublicProps {
  currentTab: InfoTab;
  changeTab: (tab: InfoTab) => void;
}

function getActiveTabIndex(currentTab: InfoTab) {
  return tabsData.findIndex(({ tab }) => {
    return currentTab === tab;
  });
}

export class AccountInfoTabs extends React.PureComponent<PublicProps> {
  public render() {
    const tabs: TabItemPublicProps[] = tabsData.map(({ tab, label }) => {
      return {
        label: label,
        onClick: () => {
          this.props.changeTab(tab);
        },
        "data-test-selector": tab
      };
    });
    return (
      <Tabs
        tabs={tabs}
        size={TabSize.Large}
        activeTabIndex={getActiveTabIndex(this.props.currentTab)}
        data-track-click="account-info-tabs"
      />
    );
  }
}
