import * as React from "react";

import { Background, Button, ButtonType, Display, Layout, StyledLayout } from "twitch-core-ui";

import { WithConfirmationModal } from "aegis/functionality/components/confirmation-modal";
import { DetailedUser } from "aegis/models";
import { DeletionReasonSelector } from "./deletion-reasons";

import "./styles.scss";

export interface PublicProps {
  cancelSelection: () => void;
  deleteContent: () => void;
  showReasonSelector: boolean;
  deleteDisabled?: boolean;
  selectDeletionReason: (reason: string) => void;
  selectedElementCount: number;
  user: DetailedUser;
}

export enum TestSelectors {
  DeleteBar = "delete-bar",
  CancelButton = "delete-bar-cancel-button",
  DeleteButton = "delete-bar-delete-button"
}

export class DeleteBarComponent extends React.Component<PublicProps> {
  public render() {
    return (
      <WithConfirmationModal
        title={`Delete User Content`}
        body={`Deleting ${this.props.selectedElementCount} piece${
          this.props.selectedElementCount > 1 ? "s" : ""
        } of content from user ${this.props.user.displayName}`}
        confirmLabelOverride="Delete"
        onConfirm={this.props.deleteContent}
      >
        {confirm => (
          <StyledLayout
            className="delete-bar"
            fullWidth
            background={Background.Overlay}
            padding={{ y: 1, x: 2 }}
            display={Display.Flex}
            data-test-selector={TestSelectors.DeleteBar}
          >
            <Layout padding={{ right: 0.5 }}>
              <Button
                type={ButtonType.Hollow}
                onClick={this.props.cancelSelection}
                overlay
                data-test-selector={TestSelectors.CancelButton}
                data-track-click="account-info-cancel-delete-selection"
              >
                Cancel
              </Button>
            </Layout>
            <Layout padding={{ right: 0.5 }}>
              <Button
                type={ButtonType.Alert}
                onClick={confirm}
                data-test-selector={TestSelectors.DeleteButton}
                data-track-click="account-info-delete-selection"
                disabled={this.props.deleteDisabled}
              >
                Delete Selected ({this.props.selectedElementCount})
              </Button>
            </Layout>
            {this.props.showReasonSelector && (
              <Layout>
                <DeletionReasonSelector reasonSelected={this.props.selectDeletionReason} />
              </Layout>
            )}
          </StyledLayout>
        )}
      </WithConfirmationModal>
    );
  }
}
