import * as React from "react";

import gql from "graphql-tag";

import { Query } from "aegis/functionality/apollo-wrapper";
import { Select } from "twitch-core-ui";

export interface PublicProps {
  reasonSelected: (reason?: string) => void;
}

export const FETCH_BADGE_REASONS = gql`
  query badgeReasons {
    deleteBadgeReasons {
      id
      display
    }
  }
`;

export interface Data {
  deleteBadgeReasons: DeleteBadgeReason[];
}

export interface DeleteBadgeReason {
  id: string;
  display: string;
}

class DeleteBadgeReasonsQuery extends Query<Data, {}> {}

export const DeletionReasonSelector: React.SFC<PublicProps> = ({ reasonSelected }) => {
  return (
    <DeleteBadgeReasonsQuery displayName="DetailedReasonSelector" query={FETCH_BADGE_REASONS}>
      {({ loading, error, data }) => {
        if (loading) {
          return <div />;
        }
        if (error || !data) {
          console.error("Couldn't fetch deletion reasons");
          return <div />;
        }

        return (
          <Select
            onChange={(e: React.FormEvent<HTMLSelectElement>) => {
              reasonSelected(e.currentTarget.value);
            }}
            overlay
          >
            <option key="none" value={""}>
              Select a reason for badge takedown
            </option>
            {data.deleteBadgeReasons.map(({ id, display }) => (
              <option key={id} value={id}>
                {display}
              </option>
            ))}
          </Select>
        );
      }}
    </DeleteBadgeReasonsQuery>
  );
};
