import * as React from "react";

import { CheckBox } from "twitch-core-ui";
import {
  AccountInfoDeleteContext,
  accountInfoDeletionContextMapper,
  DeletableTypes,
  withAccountInfoDeleteContext
} from "../context";

export interface DeleteTickPublicProps {
  contentIDs: string[];
  contentType: DeletableTypes;
  label?: string;
}

export class DeleteTickComponent extends React.Component<DeleteTickPublicProps & AccountInfoDeleteContext> {
  public render() {
    return (
      <CheckBox
        label={this.props.label || ""}
        onChange={this.onChange}
        checked={this.props.isMarked(this.props.contentType, this.props.contentIDs)}
      />
    );
  }

  private onChange = (e: React.FormEvent<HTMLInputElement>) => {
    if ((e.target as HTMLInputElement).checked) {
      this.props.markForDeletion(this.props.contentType, this.props.contentIDs);
    } else {
      this.props.unmarkForDeletion(this.props.contentType, this.props.contentIDs);
    }
  };
}

export const DeleteTick = withAccountInfoDeleteContext<AccountInfoDeleteContext, DeleteTickPublicProps>(
  accountInfoDeletionContextMapper
)(DeleteTickComponent);
